package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestLocationDAO  extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {

		try {
			DartObjectFactory.getInstance().getLocationDAO().findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		 List<Location> locationList = DartObjectFactory.getInstance().getLocationDAO().listAll();
		 
		 Assert.assertNotNull(locationList);
		 Assert.assertTrue(locationList.size() > 0);
		 
	}
	
	@Test
	public void testTwo() throws Exception {
		try {
			DartObjectFactory.getInstance().getLocationDAO().findByName(null);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		try {
			DartObjectFactory.getInstance().getLocationDAO().findByName("");
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		try {
			DartObjectFactory.getInstance().getLocationDAO().findByName("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		// find somebody to search for
		 List<Location> locationList = DartObjectFactory.getInstance().getLocationDAO().listAll();
		 
		 Assert.assertNotNull(locationList);
		 Assert.assertTrue(locationList.size() > 0);
		 
		Location loc = DartObjectFactory.getInstance().getLocationDAO().findByName(locationList.get(0).getName());
		Assert.assertNotNull(loc);
		Assert.assertTrue(locationList.get(0).equals(loc));
		 
	}
	
	@Test
	public void testThree() throws Exception {

		try {
			DartObjectFactory.getInstance().getLocationDAO().findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		
		// find somebody to search for
		 List<Location> locationList = DartObjectFactory.getInstance().getLocationDAO().listAll();
		 
		 Assert.assertNotNull(locationList);
		 Assert.assertTrue(locationList.size() > 0);
		 
		Location loc = DartObjectFactory.getInstance().getLocationDAO().findById(locationList.get(0).getId());
		Assert.assertNotNull(loc);
		Assert.assertTrue(locationList.get(0).equals(loc));

	}
	
}
